<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Exam extends Model 
{

    protected $table = 'exams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'image', 'title', 'description', 'rang');

    public function examQuestions()
    {
        return $this->hasMany('App\Models\ExamQuestion');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Models\Users');
    }

}